<?php

use App\Http\Controllers\Api\ManagerDashboard\Violations\ManagerViolationController;
use Illuminate\Support\Facades\Route;


    Route::group(['prefix' => 'manager-violations', 'controller' => ManagerViolationController::class], function () {
        // dropdowns
        Route::get('get-category/school/{school}', 'get_category_by_school');
        
        
        Route::get('get-types/violation-grade/{gradeViolation}', 'get_types');
        // get next namazeg
        Route::get('student/{student_violation}/violations', 'get_next_namazeg');


        Route::get('get-all/{school_id}', 'getAll');
        Route::get('student/{student}', 'details');
        Route::post('store', 'store');
        // تفاصي الاجراء
        Route::get('student/{student_violation}/title/{violation_title}', 'violation_title_details');
        // تطبيق نماذج فى اجراء لمخالفة طالب
        Route::post('student/{student_violation}/violation/{violation_title}', 'apply_violation_namazeg');


        Route::post('student/{student_violation}/violation/{violation_title}/skip', 'skip_violation_namazeg');
        Route::get('student/{student_violation}/violation/{violation_title}/details', 'student_violation_title_details');
        Route::post('student/{student_violation}/violation/{violation_title}/complete', 'mark_violation_title_complete');
        Route::post('student/{student_violation}/violation/{violation_title}/skip_reason', 'skip_reason');
        Route::post('step-two/{violation_student}', 'store_step_two');
        Route::post('delete/{violation_student}', 'delete');
        Route::post('violation/{student_violation}/title/{student_violation_title}/delete', 'delete_student_violation_title');
        
        
        // violation-namazeg
        Route::post('student/{student_violation}/violation/{violation_title}/store/form/{form_id}', 'store_punishment_data');
        Route::post('student/{student_violation}/violation/{violation_title}/update/form/{form_id}', 'update_punishment_data');
        Route::get('student/{student_violation}/violation/{violation_title}/details/form/{form_id}', 'get_punishment_details');
        
        Route::get('get-procedures-form-options', 'get_228_options');
        Route::get('student/{student}/degrees', 'get_student_degrees');
        Route::post('student/{student}/degrees/{violation_degrees}', 'update_student_degrees');
        
        
        // make student_violation_cycle_complete_flag
        Route::post('student/{student_violation}/flagDone', 'make_flag_done');


    });
    