<?php

use App\Http\Controllers\Api\ManagerDashboard\Tables\ClassRoomVisits\ClassRoomVisitController;
use App\Http\Controllers\Api\ManagerDashboard\Tables\ShiftSchedules\ShiftScheduleController;

use App\Http\Controllers\Api\ManagerDashboard\Supervision\SupervisionController;
use App\Http\Controllers\Api\ManagerDashboard\Tables\Exams\TableExamController;
use App\Http\Controllers\Api\ManagerDashboard\TeacherSchedule\TeacherScheduleController;
use App\Http\Controllers\Api\ManagerDashboard\Tables\WaitingPeriodsSchedule\WaitingPeriodsScheduleController;
use App\Models\AdminDashboard\School\SchoolFacilitie;
use App\Models\Day;
use App\Models\Floor;
use Illuminate\Support\Facades\Route;


/* procedures */
Route::group(['prefix' => 'tables','middleware' => ['jwt.verify']], function () {
// Route::group(['prefix' => 'tables'], function () {

    Route::group(['prefix' => 'shiftSchedules','controller' => ShiftScheduleController::class],function(){
        Route::post('get-all', 'getAll');
        Route::post('get-by-id', 'getById');
        Route::post('store', 'store');
    });

    /** exams table */
    Route::group(['prefix' => 'exams','controller' => TableExamController::class],function(){
        Route::post('get-all', 'getAll');
        Route::post('get-by-id', 'getById');
        Route::post('store/step/{step}', 'store');
        Route::post('update/step/{step}', 'update');
        Route::post('destory', 'destory');
        Route::post('update-exam-instructions', 'updateExamInstructions');
        Route::get('show-exam-instructions', 'showExamInstructions');


    });


    Route::group(['prefix' => 'classRoomVisites','controller' => ClassRoomVisitController::class],function(){
        Route::get('{school}/getAll', 'getAll');
        Route::post('{school}/semester/{semester}', 'getSemesterVisits');
        Route::post('update', 'upsert');
        Route::delete('{classRoomVisit}/destroy', 'destroy');

    });



    Route::group(['prefix' => 'supervision-schedules', 'controller' => SupervisionController::class], function () {

        Route::get('get-all', 'getAll');
        Route::get('{id}', 'getById');
        Route::post('store', 'store');
        Route::post('{id}/update', 'update');
        Route::post('{id}/delete', 'delete');
        Route::post('{id}/archive', 'archive');
        Route::post('{id}/restore', 'restore');
    });

    Route::group(['prefix' => 'teacher-schedules', 'controller' => TeacherScheduleController::class], function () {

        Route::get('get-all/{school_id}', 'getAll');
        Route::get('{id}', 'getById');
        Route::post('store', 'store');
        Route::post('{id}/update', 'update');
        Route::post('{id}/delete', 'delete');
        Route::post('{id}/archive', 'archive');
        Route::post('{id}/restore', 'restore');
        Route::get('get-teachers-with-availability/table/{table}', [TeacherScheduleController::class,'get_teachers_with_availability']);
    });


    Route::group(['prefix' => 'waiting-periods-schedule', 'controller' => WaitingPeriodsScheduleController::class], function () {

        Route::get('get-absent-teachers', 'getAbsentTeachers');
        Route::get('get-attended-teachers', 'getAttendedTeachers');
        Route::get('get-all', 'getAll');
        Route::get('{id}', 'getById');
        Route::post('store-schedule', 'storeSchedule');
        Route::post('{waitingPeriodsSchedule}/upsert-schedule-data', 'storeOrUpdateScheduleData');
        Route::post('{waitingPeriodsSchedule}/update-schedule', 'updateSchedule');
        Route::post('{id}/delete', 'delete');
        Route::post('{id}/archive', 'archive');
        Route::post('{id}/restore', 'restore');
    });



});

Route::get('all-days',function(){
    $days = Day::select('id','name')->get();
     return response()->json([
        'days' => $days
    ]);
} );

Route::get('school/{school_id}/floors',function($school_id){
    $school = SchoolFacilitie::where('school_id', $school_id)->first();
    $n_floors  = $school? $school->n_floors: 0;
    $floors = Floor::where('id','<=', $n_floors)->select('id','name')->get();
     return response()->json([
        'floors' => $floors
    ]);
} );
