<?php

use App\Http\Controllers\Api\ManagerDashboard\Settings\AdminstrativeSettingController;
use App\Http\Controllers\Api\ManagerDashboard\Settings\DataArchivingController;
use App\Http\Middleware\CheckSubscription;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\ManagerDashboard\Settings\FactoryResetController;
use App\Http\Controllers\Api\ManagerDashboard\Settings\GeneralSettingController;
use App\Http\Controllers\Api\ManagerDashboard\Settings\Subscriptions\ApplyCouponController;
use App\Http\Controllers\Api\ManagerDashboard\Settings\Subscriptions\Payment\TransactionBankController;
use App\Http\Controllers\Api\ManagerDashboard\Settings\Subscriptions\Sms\SmsSubscriptionController;
use App\Http\Controllers\Api\ManagerDashboard\Settings\Subscriptions\System\SystemSubscriptionController;

Route::group(['prefix' => 'settings'], function () {

    Route::post('apply-coupon', ApplyCouponController::class);

    Route::prefix('subscriptions')->group(function () {

        Route::prefix('sms')->controller(SmsSubscriptionController::class)->group(function () {
            Route::post('store', 'store');
        });

        Route::prefix('system')->controller(SystemSubscriptionController::class)->group(function () {
            Route::get('details', 'show');
            Route::post('renew', 'renewSubscription')->withoutMiddleware([CheckSubscription::class]);
            Route::post('company-purchases', 'companyPurchases');
            Route::delete('delete/company-purchases', 'deleteCompanyPurchases');
            Route::get('school/{school}/get/school-data', 'SchoolData');
            Route::post('/cancel-subscription', 'CancelSubscription');
        });

        Route::prefix('{subscription}/payment')->group(function () {
            // this for الدفع عن طريق التحويل البنكي
            Route::post('bank-transfer', TransactionBankController::class)->withoutMiddleware([CheckSubscription::class]);
        });
    });


    Route::group(['prefix' => 'factory-reset', 'controller' => FactoryResetController::class], function () {
        Route::post('school-employees-attendance-reset', 'schoolEmployeesAttendanceReset');
        Route::post('system-reset', 'SystemReset');
    });


    Route::group(['prefix' => 'general', 'controller' => GeneralSettingController::class], function () {
        Route::post('send-otp-before-update', 'sendOtpBeforeUpdate');
        Route::post('verify-otp-and-update-info', 'verifyOtpAndUpdateInfo');
        Route::post('change-school-type', 'changeSchoolType');
    });

    Route::group(['prefix' => 'teachers-adminstratives', 'controller' => AdminstrativeSettingController::class], function () {
        Route::post('get-school-system-users', 'getSchoolSystemUsers');
        Route::post('change-account-status', 'changeAccountStatus');
        Route::post('send-system-account-credentials', 'sendSystemAccountCredentials');
        Route::post('print-system-account-credentials', 'printSystemAccountCredentials');
        Route::post('add-new-system-account', 'addNewSystemAccount');
        Route::post('remove-system-account', 'removeSystemAccount');

        Route::post('get-permissions', 'getPermissions');
        Route::post('update-permissions', 'updatePermissions');
    });
});

Route::prefix('archives')->controller(DataArchivingController::class)->group(function () {
    Route::get('get-all', 'index');
    Route::post('/create', 'createBackup');
    Route::get('/preview/{id}', 'previewBackup');
    Route::post('/end-preview', 'endPreview');
    Route::get('/download/{id}', 'downloadBackup');
    Route::delete('/delete/{id}', 'deleteBackup');
});
