<?php

use App\Http\Controllers\Api\ManagerDashboard\Reports\EducationalAdmisnstrativeContoller;
use App\Http\Controllers\Api\ManagerDashboard\Reports\SchoolAdmisnstrativeReportController;
use App\Http\Controllers\Api\ManagerDashboard\Reports\StudentAdmisnstrativeReportController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\ManagerDashboard\Reports\ManagerReportController;

Route::group(['prefix' => 'reports','middleware' => ['ApiLocalization','jwt.verify']], function () {

    Route::group(['prefix' => 'school-manager', 'controller' => ManagerReportController::class], function () {
        Route::post('store-school-status-statistics', 'storeSchoolStatusStatisticsReport');
        Route::post('get-school-status-statistics', 'getSchoolStatusStatisticsReport');
        Route::get('get-all-school-status-statistics/{schoolId}', 'getSchoolStatusStatisticsReports');

        Route::post('store-committees-meetings-report', 'storeCommitteesMeetingsReport');
        Route::post('get-committees-meetings-report', 'getCommitteesMeetingsReport');
        Route::get('get-all-committees-meetings-reports/{schoolId}', 'getAllCommitteesMeetingsReports');

        Route::post('store-absent-late-report', 'storeAbsentLateReport');
        Route::post('get-absent-late-report', 'getAbsentLateReport');
        Route::get('get-all-absent-late-reports/{schoolId}', 'getAbsentLateReports');

        Route::post('store-administrative-work-report', 'storeAdministrativeWorkReport');
        Route::post('get-administrative-work-report', 'getAdministrativeWorkReport');
        Route::get('get-all-administrative-work-reports/{schoolId}', 'getAllAdministrativeWorkReports');
    });

    Route::group(['prefix' => 'educational-administrative', 'controller' => EducationalAdmisnstrativeContoller::class], function () {
        Route::post('store-work-report', 'storeWorkReport');
        Route::post('get-work-report', 'getWorkReport');
        Route::get('get-all-work-reports/{schoolId}', 'getAllWorkReports');

        Route::post('store-class-visits-report', 'storeClassVisitReport');
        Route::post('get-class-visits-report', 'getClassVisitReport');
        Route::get('get-all-class-visits-reports/{schoolId}', 'getAllClassVisitReports');

        Route::post('store-alerts-report', 'storeAlertReport');
        Route::post('get-alerts-report', 'getAlertReport');
        Route::get('get-all-alerts-reports/{schoolId}', 'getAllAlertReports');

    });

    Route::group(['prefix' => 'school-administrative', 'controller' => SchoolAdmisnstrativeReportController::class], function () {
        Route::post('store-work-report', 'storeWorkReport');
        Route::post('get-work-report', 'getWorkReport');
        Route::get('get-all-work-reports/{schoolId}', 'getAllWorkReports');

        Route::post('store-absent-late-report', 'storeAbsentLateReport');
        Route::post('get-absent-late-report', 'getAbsentLateReport');
        Route::get('get-all-absent-late-reports/{schoolId}', 'getAllAbsentLateReports');

    });

    Route::group(['prefix' => 'student-administrative', 'controller' => StudentAdmisnstrativeReportController::class], function () {
        Route::post('store-work-report', 'storeWorkReport');
        Route::post('get-work-report', 'getWorkReport');
        Route::get('get-all-work-reports/{schoolId}', 'getAllWorkReports');

        Route::post('store-absent-late-report', 'storeAbsentLateReport');
        Route::post('get-absent-late-report', 'getAbsentLateReport');
        Route::get('get-all-absent-late-reports/{schoolId}', 'getAllAbsentLateReports');
    });

});


