<?php

use App\Http\Controllers\Api\ManagerDashboard\Exams\Namazeg\SupervisionCommittees\AchievementCommitteeController;
use App\Http\Controllers\Api\ManagerDashboard\Exams\Namazeg\SupervisionCommittees\ControlCommitteeController;
use App\Http\Controllers\Api\ManagerDashboard\Exams\NamazegPlans\AnswerSheetProgressController;
use App\Http\Controllers\Api\ManagerDashboard\Exams\NamazegPlans\DailyObservesController;
use App\Http\Controllers\Api\ManagerDashboard\Exams\NamazegPlans\MonitorAssignmentDistribtionController;
use App\Http\Controllers\Api\ManagerDashboard\Exams\NamazegPlans\TeacherCurriculumDeclaration;
use App\Http\Controllers\Api\ManagerDashboard\Exams\NamazegPlans\TeacherQuestionAssignment;
use App\Http\Controllers\Api\ManagerDashboard\Exams\StudentCommittees\CommitteeDataController;
use App\Http\Controllers\Api\ManagerDashboard\Exams\StudentCommittees\StudentCommitteeController;
use App\Http\Controllers\Api\ManagerDashboard\Exams\SupervisionCommittees\CommitteeAssignmentController;
use App\Http\Controllers\Api\ManagerDashboard\Exams\SupervisionCommittees\CorrectionCommiteeController;
use App\Http\Controllers\Api\ManagerDashboard\Exams\SupervisionCommittees\SupervisionCommitteeController;
use Illuminate\Support\Facades\Route;



Route::group(['prefix' => 'exams'], function () {
            //لجان الإشراف على الاختبارات
    Route::group(['prefix' => 'supervisionCommittees/assignments/school/{school}', 'controller' => SupervisionCommitteeController::class], function () {
        Route::get('get-all', 'getAllCommittees');
        Route::get('committee/{committee}/show', 'show');
        Route::post('committee/{committee}/store', 'storeAssignment');
        Route::post('assignment/{assignment}/update', 'updateAssignment');
        Route::delete('assignment/{assignment}/delete', 'deleteAssignment');
    });

    Route::group(['prefix' => '/correctionCommitee/assignments/school/{school}', 'controller' => CorrectionCommiteeController::class], function () {
        Route::post('store', 'store');
        Route::get('get-all', 'getAllAssignments');
        Route::post('assignment/{assignment}/update', 'updateAssignment');
        Route::delete('assignment/{assignment}/delete', 'deleteAssignment');
    });

    // لجان الاختبارات للطلاب

    Route::group(['prefix'=>'school/{school}/studentCommittees','controller'=>StudentCommitteeController::class],function(){
        // Route::get('index','index');
        // Route::get('semester/{semester}/create','create');
        // Route::post('store','store');
        // Route::post('committee/{committee}/data-store',CommitteeDataController::class);
        // Route::get('committee/{committee}/details','show');
        // Route::delete('committee/{committee}/delete','destroy');
        // Route::delete('semester/{semester}/delete-all','deleteAllCommittees');
        // Route::get('/students/exams/applicants/total','getExamApplicantsCount');


        // new 
        Route::get('all-classes','getSchoolClasses');
        Route::get('exam-students','getExamStudentsCount');
        Route::get('committee-locations','getCommitteeLocations');
        Route::post('store-automatic-committees','storeAutomaticCommittees');
        Route::post('store-manual-committees','storeManualCommittees');
        Route::post('{committee}/assign-manual-committee-students','assignManualCommitteeStudents');
        Route::get('get-all-committees','getAllCommittees');
        Route::get('committee/{committee}/details','show');
        Route::get('/semester/{semester}/remaining-summary',  'getRemainingStudentsSummary');
        Route::delete('committee/{committee}/delete','destroy');
        Route::delete('semester/{semester}/delete-all','deleteAllCommittees');
        Route::post('duplicate-semester-committees','duplicateSemesterCommittees');
    });
    
    
        // نماذج خطة الاختبارات

    Route::group(['prefix' => 'namazeg/school/{school}'], function () {
        Route::group(['prefix' => '/teacherQuestionsAssignments'], function () {
            Route::group(['controller' => TeacherQuestionAssignment::class], function () {
                Route::post('store', 'store');
                Route::get('/', 'index');     
                Route::get('assignment/{assignment}/details', 'show'); 
                Route::post('assignment/{assignment}/update', 'update');
                Route::delete('assignment/{assignment}/delete', 'destroy');
            });
        });
        Route::group(['prefix' => '/teacherCurriculumDeclaration'], function () {
            Route::group(['controller' => TeacherCurriculumDeclaration::class], function () {
                Route::post('store', 'store');
                Route::get('/', 'index');     
                Route::get('assignment/{assignment}/details', 'show'); 
                Route::post('assignment/{assignment}/update', 'update');
                Route::delete('assignment/{assignment}/delete', 'destroy');
            });
        });
        Route::group(['prefix' => '/monitorDistribution'], function () {
            Route::group(['controller' => MonitorAssignmentDistribtionController::class], function () {
                Route::post('store', 'store');
                Route::get('/', 'index');     
                Route::post('assignment/{assignment}/update', 'update');
                Route::delete('assignment/{assignment}/delete', 'destroy');
            });
        });
        Route::group(['prefix' => '/dailyObserves'], function () {
            Route::group(['controller' => DailyObservesController::class], function () {
                Route::post('monitor/{monitor}/store', 'store');
                Route::get('/', 'index');     
                Route::get('monitor/{monitor}/details', 'show'); 
                Route::post('monitor/{monitor}/update', 'update');
                Route::delete('monitor/{monitor}/delete', 'destroy');
            });
        });
        Route::group(['prefix' => '/answerSheetProgress'], function () {
            Route::group(['controller' => AnswerSheetProgressController::class], function () {
                Route::post('store', 'store');
                Route::get('/', 'index');     
                Route::get('assignment/{assignment}/details', 'show'); 
                Route::post('assignment/{assignment}/update', 'update');
                Route::delete('assignment/{assignment}/delete', 'destroy');
            });
        });
    });
});
