<?php

namespace Database\Seeders;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\SchoolSemester;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class SemesterSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        if(SchoolSemester::count() == 0){

            $semester1 = SchoolSemester::create([
                'name' => 'الفصل الدراسي الاول',
                'start_date' => '25/09/2024',
                'end_date' => '19/12/2024',
                'start_date_type' => 'coptic',
                'end_date_type' => 'coptic',
                'period'=> 96,
                'status'=> 1,
            ]);


            $semester2 = SchoolSemester::create([
                'name' => 'الفصل الدراسي الثاني',
                'start_date' => '12/01/2025',
                'end_date' => '17/04/2025',
                'start_date_type' => 'coptic',
                'end_date_type' => 'coptic',
                'period'=> 96,
                'status'=> 1,
            ]);

            $semester3 = SchoolSemester::create([
                'name' => 'الفصل الدراسي الثالث',
                'start_date' => '04/05/2025',
                'end_date' => '07/08/2025',
                'start_date_type' => 'coptic',
                'end_date_type' => 'coptic',
                'period'=> 96,
                'status'=> '1',
            ]);

            $semester4 = SchoolSemester::create([
                'name' => 'العطلة الدارسية',
                'start_date' => NULL,
                'end_date' => NULL,
                'start_date_type' => NULL,
                'end_date_type' => NULL,
                'period'=> NULL,
                'status'=> '0',
            ]);


            Helper::saveSchoolYearCalendar('01/01/2024','31/12/2025');

            Helper::saveSemesterWeekDays($semester1->id,$semester1->start_date,$semester1->end_date);
            Helper::saveShiftSchedules($semester1->id,$semester1->start_date,$semester1->end_date);

            Helper::saveSemesterWeekDays($semester2->id,$semester2->start_date,$semester2->end_date);
            Helper::saveShiftSchedules($semester2->id,$semester2->start_date,$semester2->end_date);

            Helper::saveSemesterWeekDays($semester3->id,$semester3->start_date,$semester3->end_date);
            Helper::saveShiftSchedules($semester3->id,$semester3->start_date,$semester3->end_date);

        }
    }
}
