<?php
namespace Database\Seeders;

use App\Models\ManagerDashboard\NotificationSettings\NotificationSetting;
use Illuminate\Database\Seeder;

class NotificationSettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //disability 1 => not allow  0 => work fine
        $notifications = [
            [
                'name' => 'تأمين حصص غياب المعلم',// notify 1
                'website_disability' => 1,
                'app_disability' => 1,
                'messages_disability' => 0
            ],
            [
                'name' => 'جداول وكيلة الشؤون التعليمية',// notify2
                'website_disability' => 1,
                'app_disability' => 0,
                'messages_disability' => 1
            ],
            [
                'name' => 'تنبيهات الاجتماعات',// notify 3
                'website_disability' => 0,
                'app_disability' => 0,
                'messages_disability' => 0
            ],
            [
                'name' => 'التنبيه الشفهي',// only for message 4
                'website_disability' => 1,
                'app_disability' => 1,
                'messages_disability' => 0
            ],
            [
                'name' => 'التنبيه الخطي',// only for message 5
                'website_disability' => 1,
                'app_disability' => 1,
                'messages_disability' => 0
            ],
            [
                'name' => 'جداول المناوبة',// only for message 6
                'website_disability' => 1,
                'app_disability' => 1,
                'messages_disability' => 0
            ],
            [
                'name' => 'تنبيهات الإشراف',// only for message 7
                'website_disability' => 1,
                'app_disability' => 1,
                'messages_disability' => 0
            ],
            [
                'name' => 'تنبيهات الزيارات الصفية المتبادلة',// notify 8
                'website_disability' => 0,
                'app_disability' => 1,
                'messages_disability' => 0
            ],
            [
                'name' => 'تنبيهات إنشاء جداول الاختبارات الفترية',// notify 9
                'website_disability' => 1,
                'app_disability' => 1,
                'messages_disability' => 1
            ],
            [
                'name' => 'تنبيهات إنشاء جداول الاختبارات النهائية',// notify 10
                'website_disability' => 1,
                'app_disability' => 1,
                'messages_disability' => 1
            ],
            [
                'name' => 'تنبيهات الزيارات الصفية للمعلم',// only for message 11
                'website_disability' => 1,
                'app_disability' => 0,
                'messages_disability' => 0
            ],
            [
                'name' => 'غياب الطالبات',// only for message 12
                'website_disability' => 1,
                'app_disability' => 1,
                'messages_disability' => 0
            ],
            [
                'name' => 'تأخر الطالبات',// only for message 13
                'website_disability' => 1,
                'app_disability' => 1,
                'messages_disability' => 0
            ],
            [
                'name' => 'إجراءات الطالبات الخاصة بأولياء الأمور',// only for message 14
                'website_disability' => 1,
                'app_disability' => 1,
                'messages_disability' => 0
            ],
            [
                'name' => 'إشعار ولي الأمر عند إنشاء مخالفة',// only for message 15
                'website_disability' => 1,
                'app_disability' => 1,
                'messages_disability' => 0
            ],
            [
                'name' => 'تنبيهات عند تغيير رقم الجوال',// only for message 16
                'website_disability' => 1,
                'app_disability' => 1,
                'messages_disability' => 0
            ],
            [
                'name' => 'تنبيهات القبول والرفض للتحويلات البنكية',// only for message 17
                'website_disability' => 1,
                'app_disability' => 1,
                'messages_disability' => 0
            ],
            [
                'name' => 'حذف تأمين حصص الانتظار عند حضور المعلمة',// notify 18
                'website_disability' => 1,
                'app_disability' => 1,
                'messages_disability' => 0
            ]
        ];

        foreach ($notifications as $notification) {
            NotificationSetting::updateOrCreate([
                'name'=>$notification['name']
            ]
            ,$notification);
        }
    }
}
