<?php

namespace Database\Seeders;

use App\Models\Namazeg;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class NamazegSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $namazegRecords = [
            [
                "name" => "سجل المشكلات السلوكية",
                "details" => "سجل المشكلات السلوكية",
                "form_number" => 181,
                "data" => [
                    "basic_models" => [
                        [
                            "table" => "schools",
                            "select" => ["current_school_year"],
                            "method" => "first"
                        ]
                    ]
                ]
            ],
            [
                "name" => "سجل الزائد و الناقص و التالف",
                "details" => "سجل الزائد و الناقص و التالف",
                "form_number" => 180,
                "data" => [
                    "basic_models" => [
                        [
                            "table" => "schools",
                            "select" => ["current_school_year"],
                            "method" => "first"
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 1
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["manager_name"]
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 8 // وكيل شئون المدرسة
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["supervisor_name"]
                        ]
                    ],
                    "helper" => [
                        [
                            "method" => "getCurrentSchoolSemester",
                            "attr" => "name",
                            "withkeys" => ["semester"]
                        ]
                    ]
                ]
            ],
            [
                "name" => "كشف بموجودات المستودع العام للمدرسة",
                "details" => "كشف بموجودات المستودع العام للمدرسة",
                "form_number" => 201,
                "data" => [
                    "basic_models" => [
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 1
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["manager_name"]
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 6 // وكيل شئون التعليمية
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["studing_supervisor_name"]
                        ]
                    ]
                ]
            ],
            [
                "name" => "محضر فقد او اتلاف مادة",
                "details" => "محضر فقد او اتلاف مادة",
                "form_number" => 214,
                "data" => [
                    "basic_models" => [
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 1
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["manager_name"]
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 8 // وكيل الشؤون المدرسية
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["supervisor_name"]
                        ]
                    ]
                ]
            ],
            [
                "name" => "استمارة ابلاغ عن حالة طالبة",
                "details" => "استمارة ابلاغ عن حالة طالبة",
                "form_number" => 196,
                "data" => [
                    "basic_models" => [
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 1
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["manager_name"]
                        ]
                    ]
                ]
            ],
            [
                "name" => "سجل جرد المختبر و المواد الكيميائية",
                "details" => "سجل جرد المختبر و المواد الكيميائية",
                "form_number" => 179,
                "data" => [
                    "basic_models" => [
                        [
                            "table" => "schools",
                            "select" => ["current_school_year"],
                            "method" => "first"
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 1
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["manager_name"]
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 8 // وكيل شئون المدرسة
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["supervisor_name"]
                        ]
                    ],
                    "helper" => [
                        [
                            "method" => "getCurrentSchoolSemester",
                            "attr" => "name",
                            "withkeys" => ["semester"]
                        ]
                    ]
                ]
            ],
            [
                "name" => "سجل رصد غياب وتأخر الموظفين",
                "details" => "سجل رصد غياب وتأخر الموظفين",
                "form_number" => 177,
                "data" => [
                    "basic_models" => [
                        [
                            "table" => "schools",
                            "select" => ["current_school_year"],
                            "method" => "first"
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 1
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["manager_name"]
                        ]
                    ]
                ]
            ],
            [
                "name" => "سجل استعارة كتب للموظفين",
                "details" => "سجل استعارة كتب للموظفين",
                "form_number" => 176,
                "data" => [
                    "basic_models" => [
                        [
                            "table" => "schools",
                            "select" => ["current_school_year"],
                            "method" => "first"
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 1
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["manager_name"]
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 8
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["supervisor_name"]
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 12 // امين مصادر التعلم
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["learning_source_employee"]
                        ]
                    ],
                    "helper" => [
                        [
                            "method" => "getCurrentSchoolSemester",
                            "attr" => "name",
                            "withkeys" => ["semester"]
                        ]
                    ]
                ]
            ],
            [
                "name" => "سجل استعارة كتب للطلاب",
                "details" => "سجل استعارة كتب للطلاب",
                "form_number" => 175,
                "data" => [
                    "basic_models" => [
                        [
                            "table" => "schools",
                            "select" => ["current_school_year"],
                            "method" => "first"
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 1
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["manager_name"]
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 8
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["supervisor_name"]
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 12
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["learning_source_employee"]
                        ]
                    ],
                    "helper" => [
                        [
                            "method" => "getCurrentSchoolSemester",
                            "attr" => "name",
                            "withkeys" => ["semester"]
                        ]
                    ]
                ]
            ],
            [
                "name" => "سجل التردد اليومى",
                "details" => "سجل التردد اليومى",
                "form_number" => 174,
                "data" => [
                    "basic_models" => [
                        [
                            "table" => "schools",
                            "select" => ["current_school_year"],
                            "method" => "first"
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 1
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["manager_name"]
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 8
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["supervisor_name"]
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 12
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["learning_source_employee"]
                        ]
                    ],
                    "helper" => [
                        [
                            "method" => "getCurrentSchoolSemester",
                            "attr" => "name",
                            "withkeys" => ["semester"]
                        ]
                    ]
                ]
            ],
            [
                "name" => "سجل زيارات الفصول",
                "details" => "سجل زيارات الفصول",
                "form_number" => 173,
                "data" => [
                    "basic_models" => [
                        [
                            "table" => "schools",
                            "select" => ["current_school_year"],
                            "method" => "first"
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 1
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["manager_name"]
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 8
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["supervisor_name"]
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 12
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["learning_source_employee"]
                        ]
                    ],
                    "helper" => [
                        [
                            "method" => "getCurrentSchoolSemester",
                            "attr" => "name",
                            "withkeys" => ["semester"]
                        ]
                    ]
                ]
            ],
            [
                "name" => "سجل استئذان الموظفة أثناء الدوام",
                "details" => "سجل استئذان الموظفة أثناء الدوام",
                "form_number" => 168,
                "data" => [
                    "basic_models" => [
                        [
                            "table" => "schools",
                            "select" => ["current_school_year"],
                            "method" => "first"
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 1
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["manager_name"]
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 8
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["supervisor_name"]
                        ]
                    ],
                    "helper" => [
                        [
                            "method" => "getCurrentSchoolSemester",
                            "attr" => "name",
                            "withkeys" => ["semester"]
                        ]
                    ]
                ]
            ],
            [
                "name" => "سجل تنفيذ التجارب العلمية",
                "details" => "سجل تنفيذ التجارب العلمية",
                "form_number" => 166,
                "data" => [
                    "basic_models" => [
                        [
                            "table" => "schools",
                            "select" => ["current_school_year"],
                            "method" => "first"
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 1
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["manager_name"]
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 8
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["supervisor_name"]
                        ]
                    ],
                    "helper" => [
                        [
                            "method" => "getCurrentSchoolSemester",
                            "attr" => "name",
                            "withkeys" => ["semester"]
                        ]
                    ]
                ]
            ],
            [
                "name" => "الخطة الفصلية للتجارب العلمية",
                "details" => "الخطة الفصلية للتجارب العلمية",
                "form_number" => 165,
                "data" => [
                    "basic_models" => [
                        [
                            "table" => "schools",
                            "select" => ["current_school_year"],
                            "method" => "first"
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 1
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["manager_name"]
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 8
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["supervisor_name"]
                        ]
                    ],
                    "helper" => [
                        [
                            "method" => "getCurrentSchoolSemester",
                            "attr" => "name",
                            "withkeys" => ["semester"]
                        ]
                    ]
                ]
            ],
            [
                "name" => "سجل جرد المعامل",
                "details" => "سجل جرد المعامل",
                "form_number" => 164,
                "data" => [
                    "basic_models" => [
                        [
                            "table" => "schools",
                            "select" => ["current_school_year"],
                            "method" => "first"
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 1
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["manager_name"]
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 8
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["supervisor_name"]
                        ]
                    ],
                    "helper" => [
                        [
                            "method" => "getCurrentSchoolSemester",
                            "attr" => "name",
                            "withkeys" => ["semester"]
                        ]
                    ]
                ]
            ],
            [
                "name" => "سجل استلام عهدة",
                "details" => "سجل استلام عهدة",
                "form_number" => 163,
                "data" => [
                    "basic_models" => [
                        [
                            "table" => "schools",
                            "select" => ["name", "current_school_year"],
                            "method" => "first"
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 1
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["manager_name"]
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 8
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["supervisor_name"]
                        ],
                        [
                            "table" => "educational_departments",
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["department_name"],
                            "belongsTo" => [
                                "model" => "schools",
                                "attr" => "education_department_id",
                                "method" => "first"
                            ]
                        ],
                        [
                            "table" => "educational_offices",
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["office_name"],
                            "belongsTo" => [
                                "model" => "schools",
                                "attr" => "educational_office_id",
                                "method" => "first"
                            ]
                        ]
                    ]
                ]
            ],
            [
                "name" => "سجل متابعة آداء المعلمة",
                "details" => "سجل متابعة آداء المعلمة",
                "form_number" => 135,
                "data" => [
                    "basic_models" => [
                        [
                            "table" => "schools",
                            "select" => ["current_school_year"],
                            "method" => "first"
                        ],
                    ]
                ]
            ],
            [
                "name" => "سجل العمل الرسمى",
                "details" => "سجل العمل الرسمى",
                "form_number" => 133,
                "data" => [
                    "basic_models" => [
                        [
                            "table" => "schools",
                            "select" => ["current_school_year"],
                            "method" => "first"
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 1
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["manager_name"]
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 8
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["supervisor_name"]
                        ]
                    ],
                    "helper" => [
                        [
                            "method" => "getCurrentSchoolSemester",
                            "attr" => "name",
                            "withkeys" => ["semester"]
                        ]
                    ]
                ]
            ],
            [
                "name" => "بيان إطلاع الموظفات على التعاميم",
                "details" => "بيان إطلاع الموظفات على التعاميم",
                "form_number" => 129,
                "data" => [
                    "basic_models" => [
                        [
                            "table" => "schools",
                            "select" => ["current_school_year"],
                            "method" => "first"
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 1
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["manager_name"]
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 8
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["supervisor_name"]
                        ]
                    ],
                    "helper" => [
                        [
                            "method" => "getCurrentSchoolSemester",
                            "attr" => "name",
                            "withkeys" => ["semester"]
                        ]
                    ]
                ]
            ],
            [
                "name" => "سجل الصادر",
                "details" => "سجل الصادر",
                "form_number" => 127,
                "type" => "others",
                "internal_extenral" => "internal",
                "data" => [
                    "basic_models" => [
                        [
                            "table" => "schools",
                            "select" => ["current_school_year"],
                            "method" => "first"
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 1
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["manager_name"]
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 8
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["supervisor_name"]
                        ]
                    ],
                    "helper" => [
                        [
                            "method" => "getCurrentSchoolSemester",
                            "attr" => "name",
                            "withkeys" => ["semester"]
                        ]
                    ]
                ]
            ],
            [
                "name" => "سجل الوارد",
                "details" => "سجل الوارد",
                "form_number" => 128,
                "type" => "others",
                "internal_extenral" => "internal",
                "data" => [
                    "basic_models" => [
                        [
                            "table" => "schools",
                            "select" => ["current_school_year"],
                            "method" => "first"
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 1
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["manager_name"]
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 8
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["supervisor_name"]
                        ]
                    ],
                    "helper" => [
                        [
                            "method" => "getCurrentSchoolSemester",
                            "attr" => "name",
                            "withkeys" => ["semester"]
                        ]
                    ]
                ]
            ],
            [
                "name" => "سجل توديع المعاملات",
                "details" => "سجل توديع المعاملات",
                "form_number" => 130,
                "type" => "others",
                "internal_extenral" => "internal",
                "data" => [
                    "basic_models" => [
                        [
                            "table" => "schools",
                            "select" => ["current_school_year"],
                            "method" => "first"
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 1
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["manager_name"]
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 8
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["supervisor_name"]
                        ]
                    ],
                    "helper" => [
                        [
                            "method" => "getCurrentSchoolSemester",
                            "attr" => "name",
                            "withkeys" => ["semester"]
                        ]
                    ]
                ]
            ],
            [
                "name" => "بيان استلام المعلمين للجدول",
                "details" => "بيان استلام المعلمين للجدول",
                "form_number" => 134,
                "type" => "others",
                "internal_extenral" => "internal",
                "data" => [
                    "basic_models" => [
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "!=",
                                    "value" => 1
                                ]
                            ],
                            "select" => ["name", "ssn"],
                            "method" => "get"
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 1
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["manager_name"]
                        ]
                    ]
                ]
            ],
            [
                "name" => "متابعة تعلم الطلبة في حصص الاتقان",
                "details" => "متابعة تعلم الطلبة في حصص الاتقان",
                "form_number" => 187,
                "type" => "others",
                "internal_extenral" => "internal",
                "data" => [
                    "basic_models" => [
                        [
                            "table" => "schools",
                            "select" => ["name"],
                            "method" => "first"
                        ],
                        [
                            "table" => "educational_departments",
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["department_name"],
                            "belongsTo" => [
                                "model" => "schools",
                                "attr" => "education_department_id",
                                "method" => "first"
                            ]
                        ],
                        [
                            "table" => "school_employees",
                            "where" => [
                                [
                                    "attr" => "current_work_id",
                                    "operator" => "=",
                                    "value" => 7
                                ]
                            ],
                            "select" => ["name"],
                            "method" => "first",
                            "withkeys" => ["classes_manager"]
                        ]
                    ]
                ]
            ],
            [
                "name" => "البرامج الإرشادية المقدمة للطالب",
                "details" => "البرامج الإرشادية المقدمة للطالب",
                "form_number" => 197,
                "type" => "others",
                "internal_extenral" => "internal",
                "data" => [
                    "basic_models" => [
                        [
                            "table" => "schools",
                            "select" => ["current_school_year"],
                            "method" => "first"
                        ]
                    ]
                ]
            ],
            [
                "name" => "سجل حضور الطلاب لمجالات النشاط",
                "details" => "سجل حضور الطلاب لمجالات النشاط",
                "form_number" => 199,
                "type" => "others",
                "internal_extenral" => "internal",
                "data" => [
                    "basic_models" => [
                        [
                            "table" => "schools",
                            "select" => ["current_school_year"],
                            "method" => "first"
                        ]
                    ],
                    "helper" => [
                        [
                            "method" => "getCurrentSchoolSemester",
                            "attr" => "name",
                            "withkeys" => ["semester"]
                        ]
                    ]
                ]
            ],
            [
                "name" => "موافقة ولي امر الطالبة لمشاركة ابنته في نشاط مدرسي",
                "details" => "موافقة ولي امر الطالبة لمشاركة ابنته في نشاط مدرسي",
                "form_number" => 200,
                "type" => "others",
                "internal_extenral" => "internal",
                "data" => [
                    "basic_models" => [
                        [
                            "table" => "schools",
                            "select" => ["current_school_year"],
                            "method" => "first"
                        ]
                    ]
                ]
            ],
            ["name" => "خطة المدير", "form_number" => 131],
            ["name" => "تكليف فريق مجتمعات التعلم المهنية", "form_number" => 136],
            ["name" => "مساءلة", "form_number" => 137],
            ["name" => "نموذج الالتزام المدرس", "form_number" => 144],
            ["name" => "الخطة العامة لأنشطة حصص الاتقان للعام الدراسي", "form_number" => 186],
            ["name" => "التقرير الختامي لحصص الاتقان للعام الدراسي", "form_number" => 188],
            ["name" => "قبول طالبة", "form_number" => 158],
            ["name" => "استمارة البيانات الشخصية للطالبة", "form_number" => 191],
            ["name" => "كشف تسليم الكتب المقررة", "form_number" => 192],
            ["name" => "مساءلة غياب", "form_number" => 169],
            ["name" => "قرار حسم غياب", "form_number" => 170],
            ["name" => "تنبيه عن تأخر / انصراف", "form_number" => 171],
            ["name" => "قرار حسم مجموع ساعات تأخر و خروج مبكر", "form_number" => 172],
            ["name" => "استمارة موافقة ولي أمر الطالبة للاشتراك في النقل المدرسي", "form_number" => 167],
            ["name" => "طلب صيانة", "form_number" => 162],
            ["name" => "تقرير خطة الإخلاء", "form_number" => 189],
            ["name" => "استئذان معلمة أثناء الدوام الرسمي", "form_number" => 230],
            ["name" => "جدول الاشراف", "form_number" => 49],
            ["name" => "محضر اتلاف", "form_number" => 43],
            ["name" => "محضر فقدان", "form_number" => 44],
            ["name" => "محضر واقعة", "form_number" => 45],
            ["name" => "محضر عام", "form_number" => 46],
            ["name" => "طلب تحويل من مدارس تحفيظ القرآن الكريم و المعاهد العلمية للتعليم العام", "form_number" => 190],
            ["name" => "اجراءات المتابعه على مستوى المدرسة لحالة الطالب", "form_number" => 224],

            //الخطابات
            ["name" => "خطاب رسمي", "form_number" => 41],
            ["name" => "تبليغ", "form_number" => 38],
            ["name" => "تنبيه شفهي", "form_number" => 40],
            ["name" => "تنبيه خطي", "form_number" => 39],

            //الزيارات الصفية
            ["name" => "خطة الزيارات الصفية لمدير المدرسة", "form_number" => 202],

            // Teams
            ["name" => "فريق عمل التربية الخاصة", "form_number" => 3],
            ["name" => "فريق عمل الصندوق المدرسي", "form_number" => 4],
            ["name" => "فريق عمل الامن والسلامة المدرسية", "form_number" => 9],

            // Teams Assignments
            ["name" => "مهام واختصاصات فريق عمل التربية الخاصة", "form_number" => 28],
            ["name" => "مهام واختصاصات فريق عمل الصندوق المدرسي", "form_number" => 29],
            ["name" => " مهام واختصاصات فريق عمل الامن والسلامة المدرسية", "form_number" => 34],

            // committes
            ["name" => "لجنة الادارية للمدرسة", "form_number" => 8],
            ["name" => "لجنة التوجيه والإرشاد", "form_number" => 10],
            ["name" => "لجنة التحصيل الدراسي", "form_number" => 5],
            ["name" => "لجنة التميز", "form_number" => 6],

            // committes Assignments
            ["name" => "مهام واختصاصات اللجنة الادارية للمدرسة",  "form_number" =>  32],
            ["name" => "مهام واختصاصات لجنة التوجية والارشاد",    "form_number" =>  33],
            ["name" => "مهام واختصاصات لجنة التحصيل الدراسي",    "form_number" =>  30],
            ["name" => "مهام واختصاصات لجنة التميز ",            "form_number" =>  31],
            ["name" => "لجنة الحالات الصحية الطارئة وتعزيز الصحة", "form_number" => 36],
            ["name" => "تكليف لجنة التحصيل المعرفي بالمدرسة",    "form_number" => 183],
            ["name" => "قرار إداري", "form_number" => 35],

            // تكليفات اداره المدرسة
            ["name" => "تكليف مدير المدرسة",  "form_number" => 14],
            ["name" => "تكليف وكيل الشؤون التعليمية", "form_number" => 11],
            ["name" => "تكليف وكيل شؤون الطلاب", "form_number" => 12],
            ["name" => "تكليف وكيل الشؤون المدرسية",  "form_number" => 13],
            // تكليفات المعلمات
            ["name" => "تكليف المعلمين",  "form_number" => 18],
            ["name" => "تكليف معلمين التربية الخاصة",  "form_number" => 16],
            ["name" => "تكليف معلم الموهوبين",  "form_number" => 15],
            ["name" => "تكليف مساعد معلم التربية الخاصة",  "form_number" => 17],
            // تكليفات منسوبي المدرسة
            ["name" => "تكليف الموجه الطلابي",  "form_number" => 21],
            ["name" => "تكليف رائد النشاط",  "form_number" => 26],
            ["name" => "تكليف أمين مصادر التعليم",  "form_number" => 22],
            ["name" => "تكليف مساعد إداري",  "form_number" => 19],
            ["name" => "تكليف محضر المختبر",  "form_number" => 23],
            ["name" => "تكليف الموجه الصحي",  "form_number" => 20],
            ["name" => "تكليف مسجل المعلومات",  "form_number" => 24],
            ["name" => "تكليف الحارس",  "form_number" => 25],
            ["name" => "تكليف عامل الخدمات",  "form_number" => 27],
            //التكليفات العامة

            ["name" => "تكليف عام",  "form_number" => 37],


            // Exams supervision committee
            ["name" => "قرار تشكل لجنة التحصيل الدراسي", 'namozeg_category_id' => 27, "form_number" => 62],
            ["name" => "قرار تشكل لجنة التحكم والضبط",    'namozeg_category_id' => 27, "form_number" => 63],
            ["name" => "لجنة الإشراف و الملاحظة قرار تشكيل ", 'namozeg_category_id' => 27, "form_number" => 64],
            ["name" =>  "لجنة التصحيح و المراجعة قرار تشكيل", 'namozeg_category_id' => 27, "form_number" => 65],
            ["name" => "لجنة الرصد و إخراج النتائج قرار تشكيل", 'namozeg_category_id' => 27, "form_number" => 66],
            ["name" => "لجنة التصحيح و المراجعة وفقا للتخصص قرار تشكيل", 'namozeg_category_id' => 27, "form_number" => 67],
            // لجان الاختبارات للطلاب
            ["name" => "كشف بأسماء الطلبة وفق اللجان", 'namozeg_category_id' => 28, "form_number" => 61],
            // نماذج خطة الاختبارات

            ["name" => "قرار تكليف معلم باعداد الاسئلة ", 'namozeg_category_id' => 29, "form_number" => 68],
            ["name" => "اقرار معلم المادة  بانهاء المقررات الدراسية في وقتها المحدد", 'namozeg_category_id' => 29, "form_number" => 75],
            ["name" => "الجدول العام  لتوزيع الملاحظين على لجان الاختبارات", 'namozeg_category_id' => 29, "form_number" => 81],
            ["name" => "متابعة سير أوراق الاجابة", 'namozeg_category_id' => 29, "form_number" => 98],
            ["name" => "كشف بأسماء الملاحظين اليومي", 'namozeg_category_id' => 29, "form_number" => 82],

            // استاتك نماذج خطة الاختبارات
            ["name" => "متابعة تسليم و استلام اسئلة و نماذج الاجابة", 'namozeg_category_id' => 29, "form_number" => 69], ///////////

            ["name" => "البيانات الأولية لورقة الأسئلة", 'namozeg_category_id' => 29, "form_number" => 70],

            ["name" => "بطاقة نموذج الاحتياجات اللازمة للاختبارات", 'namozeg_category_id' => 29, "form_number" => 71],

            ["name" => "بطاقة متابعة الاستعدادات قبل الاختبارات", 'namozeg_category_id' => 29, "form_number" => 72],

            ["name" => "بطاقة متابعة الأعمال اثناء الاختبارات", 'namozeg_category_id' => 29, "form_number" => 73],

            ["name" => "بطاقة متابعة الأعمال بعد الاختبارات", 'namozeg_category_id' => 29, "form_number" => 74],

            ["name" => "متابعة تسليم المعلمين لسجلات متابعة تقويم الطلبة", 'namozeg_category_id' => 29, "form_number" => 76],

            ["name" => "ظرف أصل الأسئلة", 'namozeg_category_id' => 29, "form_number" => 77],

            ["name" => "ظرف أصل الاجابة", 'namozeg_category_id' => 29, "form_number" => 78],

            ["name" => "ظرف أسئلة الطلبة", 'namozeg_category_id' => 29, "form_number" => 79],

            ["name" => "أعداد الطلبة في الجان", 'namozeg_category_id' => 29, "form_number" => 80], ////

            ["name" => "محضر دخول معلم بديل", 'namozeg_category_id' => 29, "form_number" => 83],

            ["name" => "محضر فتح مظروف أسئلة", 'namozeg_category_id' => 29, "form_number" => 84],

            ["name" => "محضر الاخلال  بسرية الاسئلة", 'namozeg_category_id' => 29, "form_number" => 85],

            ["name" => "محضر الاخلال  بسير الاختبارات", 'namozeg_category_id' => 29, "form_number" => 86],

            ["name" => "تعهد طالب تأخر عن الاختبار بما لا يتجاوز خمس عشر دقيقة", 'namozeg_category_id' => 29, "form_number" => 87],

            ["name" => "بيان أسماء الطلبة المتأخرين بما لا يتجاوز خمس عشر دقيقة", 'namozeg_category_id' => 29, "form_number" => 88],

            ["name" => "محضر تأخر طالبا أكثر من  15 دقيقة و بما لا يتجاوز نصف الزمن ", 'namozeg_category_id' => 29, "form_number" => 89],

            ["name" => "بيان بأسماء الطلبة المتأخرين عن الاختبار أكثر من خمس عشرة دقيقة وبما لا يتجاوز نصف الزمن - تكرار تأخر ", 'namozeg_category_id' => 29, "form_number" => 90],

            ["name" => "محضر مخالفة الأنظمة و التعليمات", 'namozeg_category_id' => 29, "form_number" => 91],

            ["name" => "محضر غياب طالب عن الاختبار", 'namozeg_category_id' => 29, "form_number" => 92],

            ["name" => " كشف الغياب اليومي للطلبة أيام الاختبارات", 'namozeg_category_id' => 29, "form_number" => 93],

            ["name" => "بيان حصر الطلبة الغائبين", 'namozeg_category_id' => 29, "form_number" => 94],

            ["name" => "كفشف تسليم الطلبة أوراق الاجابة", 'namozeg_category_id' => 29, "form_number" => 95],

            ["name" => "كشف استلام اوراق الاجابة من اللجان ", 'namozeg_category_id' => 29, "form_number" => 96],

            ["name" => "ظروف أوراق اجابات  الطلبة", 'namozeg_category_id' => 29, "form_number" => 97],

            ["name" => "بيان بأسماء المصححين و المراجعين و المدققين", 'namozeg_category_id' => 29, "form_number" => 99],

            ["name" => "محضر اكتشاف الخطأ في الأسئلة", 'namozeg_category_id' => 29, "form_number" => 100],

            ["name" => "محضر اكتشاف خطأ في الإجابة النموذجية", 'namozeg_category_id' => 29, "form_number" => 101],

            ["name" => "ملاحظات لجنة التدقيق على أوراق إجابات الطلبة", 'namozeg_category_id' => 29, "form_number" => 102],

            ["name" => "تعديل درجة طالب في نظام نور  قبل إغلاق الدرجات", 'namozeg_category_id' => 29, "form_number" => 103],

            ["name" => "تعديل درجة طالب في نظام نور  بعد إغلاق الدرجات", 'namozeg_category_id' => 29, "form_number" => 104],

            ["name" => "طلب رصد درجة طالب غائب عن اختبار /بعذر في نظام نور", 'namozeg_category_id' => 29, "form_number" => 105],

            ["name" => "طلب مراجعة  ورقة طالب", 'namozeg_category_id' => 29, "form_number" => 106],

            ["name" => "دفتر رصد درجات أعمال السنة واختبار نهاية الفصول الدراسية", 'namozeg_category_id' => 29, "form_number" => 107],


            // Manager Violation

            ["name" => "تقويم السلوك", "form_number" => 1, "type" => "others"],
            ["name" => "استدعاء جهة امنية", "form_number" => 132, "type" => "violations"],
            ["name" => "الاتفاق السلوكى", "form_number" => 139, "type" => "violations"],
            ["name" => "خطة تعديل السلوك", "form_number" => 140, "type" => "violations"],
            ["name" => "محضر اصلاح ما افسده الطالب", "form_number" => 141, "type" => "violations"],
            ["name" => "محضر ضبط الواقعة", "form_number" => 142, "type" => "violations"],
            ["name" => "محضر مخالفة سلوكية", "form_number" => 143, "type" => "violations"],
            ["name" => "محضر اثبات واقعة", "form_number" => 145, "type" => "violations"],
            ["name" => "خطاب دعوة", "form_number" => 146, "type" => "violations"],
            ["name" => "اشعار ولى الامر الطالب", "form_number" => 147, "type" => "violations"],
            ["name" => "احالة اطلب للموجه الطلابى", "form_number" => 148, "type" => "violations"],
            ["name" => "اشعار حسم", "form_number" => 149, "type" => "violations"],
            ["name" => "احالة الى لجنة التوجية والارشاد فى المدرسة", "form_number" => 150, "type" => "violations"],
            ["name" => "اشعار ولى الامر بنقل الطالب من المدرسة", "form_number" => 151, "type" => "violations"],
            ["name" => "انذار نقل الطالب الى مدرسة اخرى", "form_number" => 152, "type" => "violations"],
            ["name" => "تعهد", "form_number" => 154, "type" => "violations"],
            ["name" => "محضر اتلاف", "form_number" => 157, "type" => "violations"],
            ["name" => "نموذج رصد السلوك المخالف", "form_number" => 159, "type" => "violations"],
            ["name" => "نموذج لاحالة لادارة قسم التوجيه الطلابى", "form_number" => 160, "type" => "violations"],
            ["name" => "محضر اجتماع لجنة التوجيه الطلابى بالمدرسة", "form_number" => 161, "type" => "violations"],
            ["name" => "انذار تحويل طالب الى انتساب", "form_number" => 222, "type" => "violations"],
            ["name" => "اشعار ولى الامر", "form_number" => 228, "type" => "violations"],
            ["name" => "اشعار ولى الامر بتحويل ابنه لانتساب", "form_number" => 232, "type" => "violations"],
            ["name" => "نموذج إجراءات إدارة التعليم (إشعار ولي الأمر)", "form_number" => 228, "type" => "violations"],
            ["name" => "نموذج المخالفة الكاملة", "form_number" => 108, "type" => "others"],

            // المواظبه
            ["name" => "الإجراءات الواجب اتخاذها حيال غياب الطلاب", "form_number" => 2, "type" => "others"],
            ["name" => "الإجراءات الواجب اتخاذها حيال تأخير طلاب المرحلتين المتوسطة والثانوية", "form_number" => 227, "type" => "others"],

            ["name" => "إحالة طالب للموجه الطلابي", "form_number" => 215, "type" => "lateness_procedures"],
            ["name" => "إحالة طالب للموجه الطلابي", "form_number" => 216, "type" => "absence_procedures"],
            ["name" => "تعهد ولي أمر طالب متكرر الغياب", "form_number" => 218, "type" => "absence_procedures"],
            ["name" => "إنذار اول لطالب متكرر الغياب", "form_number" => 260, "type" => "absence_procedures"],
            ["name" => "إنذار ثاني لطالب متكرر الغياب", "form_number" => 261, "type" => "absence_procedures"],
            ["name" => "إنذار ثالث لطالب متكرر الغياب", "form_number" => 262, "type" => "absence_procedures"],
            ["name" => "إشعار ولي أمر طالب متكرر الغياب", "form_number" => 263, "type" => "absence_procedures"],

            // الجداول
            ["name" => "جدول تأمين حصص الانتظار", "form_number" => 51, "type" => "others"],
            ["name" => "جدول المناوبة الاسبوعي", "form_number" => 47, "type" => "others"],
            ["name" => "تقرير المناوبة", "form_number" => 48, "type" => "others"],
            ["name" => "الاختبارات الفترية", "form_number" => 233, "type" => "others"],

            ["name" => " جدول الاختبارات مختلف لكل فصل", "form_number" => 234, "type" => "others"],
            ["name" => " جدول الاختبارات مختلف لكل فصل", "form_number" => 235, "type" => "others"],

            ["name" => "جدول الاختبارات العام للمرحلة الابتدائية تعميد عام", "form_number" => 238, "type" => "others"],
            ["name" => "جدول الاختبارات العام للمرحلة الابتدائية", "form_number" => 239, "type" => "others"],

            ["name" => "جدول الاختبارات العام للمرحلة الاعدادية تعميد عام", "form_number" => 240, "type" => "others"],
            ["name" => "جدول الاختبارات العام للمرحلة الاعدادية", "form_number" => 241, "type" => "others"],

            ["name" => "جدول الاختبارات العام للمرحلة الثانوية تعميد عام", "form_number" => 242, "type" => "others"],
            ["name" => "جدول الاختبارات العام للمرحلة الثانوية", "form_number" => 243, "type" => "others"],

            ["name" => "جدول الاختبارات العام للصف الاول الثانوي تعميد عام", "form_number" => 244, "type" => "others"],
            ["name" => "جدول الاختبارات العام للصف الاول الثانوي", "form_number" => 245, "type" => "others"],

            ["name" => "جدول الاختبارات العام للصفوف مسارات تعميد عام", "form_number" => 246, "type" => "others"],
            ["name" => "جدول الاختبارات العام للصفوف مسارات", "form_number" => 247, "type" => "others"],

            ["name" => "جدول الاختبارات العام لكل صف دراسي", "form_number" => 248, "type" => "others"],


            ["name" => "جدول اختبار الشفهي والعملي  المواد زات الجانبين للمرحلة الابتدائية تعميد عام", "form_number" => 249, "type" => "others"],
            ["name" => "جدول اختبار الشفهي والعملي  المواد زات الجانبين للمرحلة الابتدائية", "form_number" => 250, "type" => "others"],
            ["name" => "جدول اختبار الشفهي والعملي  المواد زات الجانبين للمرحلة الاعدادية تعميد عام", "form_number" => 251, "type" => "others"],
            ["name" => "جدول اختبار الشفهي والعملي  المواد زات الجانبين للمرحلة الاعدادية", "form_number" => 252, "type" => "others"],
            ["name" => "جدول اختبار الشفهي والعملي  المواد زات الجانبين للمرحلة الثانوية تعميد عام", "form_number" => 253, "type" => "others"],
            ["name" => "جدول اختبار الشفهي والعملي  المواد زات الجانبين للمرحلة الثانوية ", "form_number" => 254, "type" => "others"],
            ["name" => "جدول اختبار الشفهي والعملي  المواد زات الجانبين الصف الاول الثانوي تعميد عام", "form_number" => 255, "type" => "others"],
            ["name" => "جدول اختبار الشفهي والعملي  المواد زات الجانبين الصف الاول الثانوي ", "form_number" => 256, "type" => "others"],
            ["name" => "جدول اختبار الشفهي والعملي  المواد زات الجانبين للصفوف مسارات تعميد عام", "form_number" => 257, "type" => "others"],
            ["name" => "جدول اختبار الشفهي والعملي  المواد زات الجانبين للصفوف مسارات", "form_number" => 258, "type" => "others"],
            ["name" => "جدول اختبار الشفهي والعملي  المواد زات الجانبين للصفوف", "form_number" => 259, "type" => "others"],



                // التعاميم
            ["name" => "تعميم داخلي", "form_number" => 42, "type" => "others"],
            ["name" => "بيان عام (للمعلمين)", "form_number" => 225, "type" => "others"],
            ["name" => "بيان عام (للطلاب)", "form_number" => 226, "type" => "others"],

            //التقارير
            ["name" => "تقرير الغياب للمعلمين", "form_number" => 264, "type" => "others"],
            ["name" => "تقرير تأخر للمعلمين", "form_number" => 265, "type" => "others"],
            ["name" => "التقرير الأسبوعي لغياب الطلاب للمعلمين-خاص بالمعلم", "form_number" => 266, "type" => "others"],
            ["name" => "التقرير اليومي للغياب للطلاب-خاص بوكيل شؤون الطلاب-غياب", "form_number" => 267, "type" => "others"],
            ["name" => "التقرير الأسبوعي لغياب الطلاب-خاص بوكيل شؤون الطلاب-غياب", "form_number" => 268, "type" => "others"],
            ["name" => "التقرير الفصلي لغياب الطلاب-خاص بوكيل شؤون الطلاب-غياب", "form_number" => 269, "type" => "others"],
            ["name" => "التقرير يومي للتأخير الطلاب-تأخر", "form_number" => 270, "type" => "others"],
            ["name" => "التقرير اسبوعي للتأخير الطلاب-تأخر", "form_number" => 271, "type" => "others"],
            ["name" => "التقرير الفصلي للتأخير الطلاب-تأخر", "form_number" => 272, "type" => "others"],


            // Namazeg/Covers


            // TeacherBoard Namazeg
            // ["name" => "تحويل طالبة لوكيل شئون الطلاب", "form_number" => 138, "type" => "others"],
            // ["name" => "تحويل طالب متكرر الغياب والتأخر لوكيل شؤون الطلاب", "form_number" => 193, "type" => "others"],

            //  جدول الزيارات الصفية  المتبادلة
            ["name" => "برنامج تبادل الزيارات الصفية", "form_number" => 50, "type" => "others"],
            ["name" => "استمارة تبادل زيارات الصفية", "form_number" => 229, "type" => "others"],
            // سجل الزياره الصفية
            ["name" =>"سجل الزيارة الصفية", "form_number" => 273],


        ];

        foreach ($namazegRecords as $record) {
            Namazeg::updateOrCreate(
                ['form_number' => $record['form_number']],
                $record
            );
        }


        /**
         *
         {
             "name": "سجل الوارد",
             "details": "سجل الوارد",
             "form_number": "128",
             "type": "others",
             "internal_extenral": "internal",
             "data": {
                 "basic_models": [
                     {
                         "table": "schools",
                         "select":["current_school_year"],
                         "method":"first"
                     }
                 ]
             }
         }
         *

       {
           "name": "سجل توديع المعاملات",
           "details": "سجل توديع المعاملات",
           "form_number": "130",
           "type": "others",
           "internal_extenral": "internal",
           "data": {
               "basic_models": [
                   {
                       "table": "schools",
                       "select":["current_school_year"],
                       "method":"first"
                   }
               ]
           }
       }


       {
           "name": "بيان استلام المعلمين للجدول",
           "details": "بيان استلام المعلمين للجدول",
           "form_number": "134",
           "type": "others",
           "internal_extenral": "internal",
           "data": {
               "basic_models": [
                   {
                       "table": "school_employees",
                       "where": [
                           {
                               "attr": "current_work_id",
                               "operator": "!=",
                               "value": 1
                           }
                       ],
                       "select": [
                           "name",
                           "ssn"
                       ],
                       "method": "get"
                   },
                   {
                       "table": "school_employees",
                       "where": [
                           {
                               "attr": "current_work_id",
                               "operator": "=",
                               "value": 1
                           }
                       ],
                       "select": [
                           "name"
                       ],
                       "method": "first",
                       "withkeys": [
                           "manager_name"
                       ]
                   }
               ]
           }
       }


       {
            "name": "متابعة تعلم الطلبة في حصص الاتقان",
            "details": "متابعة تعلم الطلبة في حصص الاتقان",
            "form_number": "187",
            "type": "others",
            "internal_extenral": "internal",
            "data": {
                "basic_models": [
                    {
                        "table": "schools",
                        "select": [
                            "name"
                        ],
                        "method": "first"
                    },
                    {
                        "table": "educational_departments",
                        "select": [
                            "name"
                        ],
                        "method": "first",
                        "withkeys": [
                            "department_name"
                        ],
                        "belongsTo":{
                            "model":"schools",
                            "attr":"education_department_id",
                            "method": "first"
                        }

                    }
                ]
            }
        }

        {
           "name": "البرامج الإرشادية المقدمة للطالب",
           "details": "البرامج الإرشادية المقدمة للطالب",
           "form_number": "197",
           "type": "others",
           "internal_extenral": "internal",
           "data": {
               "basic_models": [
                   {
                       "table": "schools",
                       "select":["current_school_year"],
                       "method":"first"
                   }
               ]
           }
       }
        {
            "name": "سجل حضور الطلاب لمجالات النشاط",
            "details": "سجل حضور الطلاب لمجالات النشاط",
            "form_number": "199",
            "type": "others",
            "internal_extenral": "internal",
            "data": {
                "basic_models": [
                    {
                        "table": "schools",
                        "select": [
                            "current_school_year"
                        ],
                        "method": "first"
                    }
                ],
                "helper": [
                    {
                        "method": "getCurrentSchoolSemester",
                        "attr": "name",
                        "withkeys": [
                            "semester"
                        ]
                    }
                ]
            }
        }
        {
            "name": "موافقة ولي امر الطالبة لمشاركة ابنته في نشاط مدرسي",
            "details": "موافقة ولي امر الطالبة لمشاركة ابنته في نشاط مدرسي",
            "form_number": "200",
            "type": "others",
            "internal_extenral": "internal",
            "data": {
                "basic_models": [
                    {
                        "table": "schools",
                        "select": [
                            "current_school_year"
                        ],
                        "method": "first"
                    }
                ]
            }
        }
         *
         */
    }
}
