<?php

namespace Database\Seeders;

use App\Models\ManagerDashboard\OfficialSpeeches\Alert;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class AlertSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Alert::factory()
            ->count(20)
            ->create()
            ->each(function ($alert) {
                // Create 3 notes for each alert
                \App\Models\ManagerDashboard\OfficialSpeeches\AlertNote::factory()
                    ->count(3)
                    ->create(['alert_id' => $alert->id]);
            });
    }
}
