    <?php

    use Illuminate\Database\Migrations\Migration;
    use Illuminate\Database\Schema\Blueprint;
    use Illuminate\Support\Facades\Schema;

    return new class extends Migration
    {
        /**
         * Run the migrations.
         */
        public function up(): void
        {
            Schema::table('class_visit_cards', function (Blueprint $table) {
                // Step 1: Rename the column first
                $table->renameColumn('teacher_nationality', 'teacher_nationality_id');
            });

            // Step 2: After renaming, modify the column type
            Schema::table('class_visit_cards', function (Blueprint $table) {
                // Modify the column type to unsignedBigInteger
                $table->unsignedBigInteger('teacher_nationality_id')->nullable()->change();

                // Step 3: Set the foreign key constraint
                $table->foreign('teacher_nationality_id')
                    ->references('id')
                    ->on('nationalities')
                    ->onDelete('set null'); // Optional: Set to null on delete

                // Step 4: Drop the 'qualification_date_type' column
                $table->dropColumn('qualification_date_type');
            });
        }

        /**
         * Reverse the migrations.
         */
        public function down(): void
        {
            Schema::table('class_visit_cards', function (Blueprint $table) {
                // Step 1: Drop the foreign key constraint
            $table->dropForeign(['teacher_nationality_id']);

            // Step 2: Change the column type back to string
            $table->string('teacher_nationality_id')->nullable()->change();

            // Step 3: Rename the column back to 'teacher_nationality'
            $table->renameColumn('teacher_nationality_id', 'teacher_nationality');

            // Step 4: Re-add the 'qualification_date_type' column
            $table->string('qualification_date_type')->nullable();
            });
        }
    };
