<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('classroom_visits', function (Blueprint $table) {
            // Drop existing foreign keys
            $table->dropForeign(['visiting_teacher_id']);
            $table->dropForeign(['visited_teacher_id']);
            $table->dropForeign(['period_id']);
            $table->dropForeign(['subject_id']);

            // Add new foreign keys with cascade on delete
            $table->foreign('visiting_teacher_id')
                  ->references('id')
                  ->on('school_employees')
                  ->onDelete('cascade');

            $table->foreign('visited_teacher_id')
                  ->references('id')
                  ->on('school_employees')
                  ->onDelete('cascade');

            $table->foreign('period_id')
                  ->references('id')
                  ->on('periods')
                  ->onDelete('cascade');

            $table->foreign('subject_id')
                  ->references('id')
                  ->on('subjects')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('classroom_visits', function (Blueprint $table) {
            // Drop modified foreign keys
            $table->dropForeign(['visiting_teacher_id']);
            $table->dropForeign(['visited_teacher_id']);
            $table->dropForeign(['period_id']);
            $table->dropForeign(['subject_id']);

            // Restore original foreign keys without cascade on delete
            $table->foreign('visiting_teacher_id')
                  ->references('id')
                  ->on('school_employees');

            $table->foreign('visited_teacher_id')
                  ->references('id')
                  ->on('school_employees');

            $table->foreign('period_id')
                  ->references('id')
                  ->on('periods');

            $table->foreign('subject_id')
                  ->references('id')
                  ->on('subjects');
        });
    }
};
