<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('table_exam_days', function (Blueprint $table) {
            if (!Schema::hasColumn('table_exam_days', 'class_name_category')) {
                $table->string('class_name_category')->nullable()->after('class_name_id');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('table_exam_days', function (Blueprint $table) {
            if (Schema::hasColumn('table_exam_days', 'class_name_category')) {
                $table->dropColumn('class_name_category');
            }
        });
    }
};
