<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->enum('status', ['active', 'inactive', 'block' ,'canceled','canceled_by_user','finished'])
                ->default('inactive')
                ->charset('utf8mb4')
                ->collation('utf8mb4_unicode_ci')
                ->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->enum('status', ['active', 'inactive', 'block'])
                ->default('inactive')
                ->charset('utf8mb4')
                ->collation('utf8mb4_unicode_ci')
                ->change();
        });
    }
};
