<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('subscriptions', function (Blueprint $table) {
            $table->string('cancellation_request_status')->after('invoice_number')->comment('pending ,requested , accepted , refused')->nullable();
            $table->string('admin_response')->after('cancellation_request_status')->comment('accepted , refused')->nullable();

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('subscriptions', function (Blueprint $table) {
            $table->dropColumn('cancellation_request_status');
            $table->dropColumn('admin_response');
        });
    }
};
