<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('class_room_visit_sessions', function (Blueprint $table) {
            $table->unsignedBigInteger('subject_id')->nullable()->after('visit_period_id');

            $table->foreign('subject_id')->references('id')->on('subjects');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('class_room_visit_sessions', function (Blueprint $table) {
            $table->dropForeign('subject_id');
            $table->dropColumn('subject_id');
        });
    }
};
