<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transaction_payment_gateway_data', function (Blueprint $table) {
            $table->id();
            $table->foreignId('subscription_id')->constrained()->onDelete('cascade');
            $table->bigInteger('transaction_number')->nullable();
            $table->string('payment_method')->nullable();
            $table->decimal('payment_gateway_discount_percentage', 5, 2)->nullable();
            $table->integer('order_amount')->nullable();
            $table->timestamp('trans_date')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transaction_payment_gateway_data');
    }
};
