<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('subscriptions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('product_id')->constrained()->nullable()->onDelete('restrict');
            $table->string('start_date')->nullable();
            $table->string('end_date')->nullable();
            $table->string('status')->nullable()->comment('Experimental,subscribed,not_subscribed');
            $table->string('service_type')->nullable()->comment('system,sms');
            $table->integer('messages_consumed')->nullable();
            $table->string('paid_type')->nullable()->comment('bank_transfer , payment_gateway');
            $table->bigInteger('order_number')->unique()->nullable();
            $table->string('paid_status')->nullable()->comment('panding,confirm,refused,refunded');
            $table->integer('subscription_fee')->nullable();
            $table->integer('coupon_discount')->nullable();
            $table->foreignId('coupon_id')->nullable()->constrained()->onDelete('cascade');
            $table->integer('tax_fees')->nullable();
            $table->integer('total_price')->nullable();
            $table->bigInteger('invoice_number')->unique()->nullable();
            $table->longText('cancellation_reason')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('subscriptions');
    }
};
