<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('namazeg_manager_plane_details', function (Blueprint $table) {
            $table->unsignedBigInteger('namazeg_manager_plane_id')->change();
            $table->foreign('namazeg_manager_plane_id','namazeg_manager_id')->references('id')->on('namazeg_manager_planes')
                ->onDelete('cascade'); // You can also use other actions, e.g., 'set null'
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('namazeg_manager_plane_details', function (Blueprint $table) {
            $table->dropForeign(['namazeg_manager_plane_id']);
        });
    }
};
