<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('shift_teachers', function (Blueprint $table) {
            // Drop the foreign key constraint first
            $table->dropForeign(['school_employee_id']);
        });

        Schema::table('shift_teachers', function (Blueprint $table) {
            // Change the column type from BIGINT to VARCHAR
            $table->string('school_employee_id', 191)->nullable()->change();
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('shift_teachers', function (Blueprint $table) {

            // Change the column type back to BIGINT
            $table->bigInteger('school_employee_id')->change();

            // Recreate foreign key if necessary (adjust as needed)
            // $table->foreign('school_employee_id')->references('id')->on('your_related_table');
        });
    }
};
