<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('std_absence_procedures_sub_items', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('main_item_id');
            $table->unsignedBigInteger('procedure_id');
            $table->unsignedBigInteger('namozeg_version_id');
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('main_item_id')->references('id')->on('std_absence_procedures_main_items')->onDelete('cascade');
            $table->foreign('procedure_id')->references('id')->on('absence_procedures')->onDelete('cascade');
            $table->foreign('namozeg_version_id')->references('id')->on('namazeg_versions')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('std_absence_procedures_sub_items');
    }
};
