<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('events', function (Blueprint $table) {
            // Step 1: Add new columns
            $table->string('title')->after('id');
            $table->string('date_from')->after('title'); // Add the new column for 'date_from'
            $table->string('date_to')->after('date_from'); // Add the new column for 'date_to'
            $table->boolean('holiday')->default(false)->after('date_to'); // Add the 'holiday' column
        });

        // Step 2: Copy data from 'date' to 'date_from' (you can also do this manually if needed)
        DB::table('events')->update(['date_from' => DB::raw('date')]);

        // Step 3: Drop old columns
        Schema::table('events', function (Blueprint $table) {
            $table->dropColumn('date'); // Drop the old 'date' column
            $table->dropColumn('time_from'); // Drop 'time_from'
            $table->dropColumn('time_to'); // Drop 'time_to'
            $table->dropColumn('date_type'); // Drop 'date_type'
            $table->dropColumn('details'); // Drop 'details
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('events', function (Blueprint $table) {
            $table->renameColumn('date_from', 'date');
            $table->enum('date_type', ['coptic', 'hijri']);
            $table->time('time_from')->nullable();
            $table->time('time_to')->nullable();
            $table->renameColumn('title','details');
            $table->dropColumn('date_to');
            $table->dropColumn('holiday');
        });
    }
};
