<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('exams_namazeg_distribution_assignment_monitors', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('md_assignment_id');
            $table->unsignedBigInteger('employee_id');
            $table->string('date');
            $table->string('date_type')->nullable();
            $table->json('period')->nullable();
            $table->timestamps();
            $table->softDeletes();


            $table->foreign('md_assignment_id','md_assignment_fk')->references('id')->on('exams_namazeg_monitor_distribution_assignments')->onDelete('cascade');
            $table->foreign('employee_id','employee_fk')->references('id')->on('school_employees')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('exams_namazeg_distribution_assignment_monitors');
    }
};
