<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('students_lateness', function (Blueprint $table) {
            $table->unsignedBigInteger('semester_id')->after('school_id')->nullable();

            $table->foreign('semester_id')->references('id')->on('semesters')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('students_lateness', function (Blueprint $table) {
            Schema::dropIfExists('semester_id');
        });
    }
};
