<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('student_violation_degrees', function (Blueprint $table) {
            $table->unsignedBigInteger('violation_category_id')->nullable();
            $table->unsignedBigInteger('violation_grade_id')->nullable();
            $table->foreign('violation_category_id')->references('id')->on('violations')->onDelete('cascade');
            $table->foreign('violation_grade_id')->references('id')->on('violation_grades')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('student_violation_degrees', function (Blueprint $table) {
            $table->dropColumn('violation_category_id');
            $table->dropColumn('violation_grade_id');
        });
    }
};