<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('namazeg_redirect_guidances', function (Blueprint $table) {
            $table->id();
            $table->foreignId('v_student_punishment_id');
            $table->foreign('v_student_punishment_id', 'fk_v_student_punishment_id_4')
                ->references('id')->on('violation_student_punishments')
                ->cascadeOnDelete();

            $table->foreignId('namazeg_version_id');
            $table->foreign('namazeg_version_id', 'fk_namazeg_version_id_4')
                ->references('id')->on('namazeg_versions')
                ->cascadeOnDelete();

            $table->foreignId('student_id');
            $table->foreign('student_id', 'fk_student_id_4')
                ->references('id')->on('school_students')
                ->cascadeOnDelete();



            $table->text('redirect_reason');
            $table->text('attach_reason');
            $table->boolean('attach');
            $table->string('not_response_reason');
            $table->string('phone');
            $table->text('actions');

            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('namazeg_redirect_guidances');
    }
};
