<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('namazeg_incident_proceed_witnesses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('namazeg_incident_proceed_id')->on('id')->table('namazeg_incident_proceeds')->onCascade('delete');
            $table->foreignId('employee_id')->on('id')->table('school_employees')->onCascade('delete');
            $table->string('his_work')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('namazeg_incident_proceed_witnesses');
    }
};
