<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('namazeg_absence_questioning_actions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('absence_questioning_id')
            ->constrained('namazeg_absence_questionings')->onDelete('cascade')
                ->name('fk_absence_questioning_id');
            $table->foreignId('absence_questioning_option_id')
            ->constrained('namazeg_absence_questioning_options')->onDelete('cascade')
                ->name('fk_absence_questioning_option_id');
            $table->string('serial_number');
            $table->integer('absence_descion_confirm_id')->nullable();
            $table->string('report_type')->nullable();
            $table->string('n_days')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('namazeg_absence_questioning_actions');
    }
};
