<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('report_student_adminstrative_absent_lates', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('school_id')->nullable();  // school_id INT(11), NULL allowed
            $table->unsignedBigInteger('report_category_id')->nullable();  // school_id UNSIGNED INT, NOT NULL
            $table->enum('report_category', ['late_teachers', 'absent_teachers', 'late_students', 'absent_students'])->nullable();  // ENUM for report_category
            $table->enum('report_type', ['daily', 'weekly', 'classy'])->nullable();  // ENUM for report_type
            $table->unsignedBigInteger('class_name_id')->nullable();  // class_name_id INT(11), NULL allowed
            $table->unsignedBigInteger('class_id')->nullable();  // class_id INT(11), NULL allowed
            $table->unsignedBigInteger('semester_id')->nullable();  // semester_id INT(11), NULL allowed
            $table->unsignedBigInteger('week_id')->nullable();  // week_id INT(11), NULL allowed
            $table->unsignedBigInteger('namazeg_version_id')->nullable();  // namazeg_version_id INT(11) DEFAULT NULL
            $table->string('date')->nullable();
            $table->enum('date_type', ['coptic', 'hijri'])->nullable();
            $table->timestamp('created_at')->nullable();  // created_at TIMESTAMP, NULL allowed
            $table->timestamp('updated_at')->nullable();  // updated_at TIMESTAMP, NULL allowed
            $table->softDeletes();  // Adds 'deleted_at' TIMESTAMP, NULL allowed

            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
            $table->foreign('class_name_id')->references('id')->on('class_names')->onDelete('cascade');
            $table->foreign('class_id')->references('id')->on('school_classes')->onDelete('cascade');
            $table->foreign('semester_id')->references('id')->on('semesters')->onDelete('cascade');
            $table->foreign('week_id')->references('id')->on('weeks')->onDelete('cascade');
            //$table->foreign('report_category_id')->references('id')->on('report_categories')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('report_student_adminstrative_absent_lates');
    }
};
