<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('report_school_adminstrative_absent_lates', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('school_id')->nullable();  // school_id UNSIGNED INT, NOT NULL
            $table->unsignedBigInteger('report_category_id')->nullable();  // school_id UNSIGNED INT, NOT NULL
            $table->string('date')->nullable();
            $table->enum('date_type', ['coptic', 'hijri'])->nullable();
            $table->enum('report_category', ['late_teachers', 'absent_teachers'])->nullable();  // ENUM for report_category
            $table->unsignedBigInteger('namazeg_version_id')->nullable();  // namazeg_version_id INT(11) DEFAULT NULL
            $table->timestamp('created_at')->nullable();  // created_at TIMESTAMP, NULL allowed
            $table->timestamp('updated_at')->nullable();  // updated_at_time TIMESTAMP, NULL allowed
            $table->softDeletes();  // Adds deleted_at TIMESTAMP, NULL allowed

            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
            //$table->foreign('report_category_id')->references('id')->on('report_categories')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('report_school_adminstrative_absent_lates');
    }
};
