<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('report_educational_adminstrative_works', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('school_id')->nullable();  // school_id UNSIGNED INT, NOT NULL
            $table->unsignedBigInteger('report_category_id')->nullable();  // report_category_id UNSIGNED INT, NOT NULL
            $table->enum('report_type', ['daily', 'period', 'monthly'])->nullable();  // ENUM for report_type
            $table->string('date')->nullable();
            $table->enum('date_type', ['coptic', 'hijri'])->nullable();

            $table->string('date_from')->nullable();
            $table->enum('date_from_type', ['coptic', 'hijri'])->nullable();
            $table->string('date_to')->nullable();
            $table->enum('date_to_type', ['coptic', 'hijri'])->nullable();
            $table->string('month')->nullable();
            $table->unsignedInteger('namazeg_version_id')->nullable();  // namazeg_version_id UNSIGNED INT, NOT NULL
            $table->timestamp('created_at')->nullable();  // created_at TIMESTAMP, NULL allowed
            $table->timestamp('updated_at')->nullable();  // updated_at_time TIMESTAMP, NULL allowed
            $table->softDeletes();  // Adds deleted_at TIMESTAMP, NULL allowed

            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
            //$table->foreign('report_category_id')->references('id')->on('report_categories')->onDelete('cascade');

        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('report_educational_adminstrative_works');
    }
};
