<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('report_administrative_works', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('report_category_id')->nullable();  // report_category_id UNSIGNED INT, NOT NULL
            $table->unsignedBigInteger('school_id');  // school_id UNSIGNED INT, NOT NULL
            $table->unsignedBigInteger('current_work_id');  // current_work_id UNSIGNED INT, NOT NULL
            $table->enum('report_type', ['daily', 'period', 'monthly']);  // ENUM for report_type
            $table->string('date')->nullable();
            $table->enum('date_type', ['coptic', 'hijri'])->nullable();

            $table->string('date_from')->nullable();
            $table->enum('date_from_type', ['coptic', 'hijri'])->nullable();
            $table->string('date_to')->nullable();
            $table->enum('date_to_type', ['coptic', 'hijri'])->nullable();
            $table->string('month')->nullable();

            $table->unsignedBigInteger('namazeg_version_id')->nullable();  // namazeg_version_id UNSIGNED INT, NOT NULL
            $table->timestamp('created_at')->nullable();  // created_at TIMESTAMP, NULL allowed
            $table->timestamp('updated_at')->nullable();  // updated_at TIMESTAMP, NULL allowed
            $table->softDeletes();  // Adds deleted_at TIMESTAMP, NULL allowed

            // Foreign keys
            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
            //$table->foreign('report_category_id')->references('id')->on('report_categories')->onDelete('cascade');
            $table->foreign('current_work_id')->references('id')->on('current_works')->onDelete('cascade');
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('report_administrative_works');
    }
};
