<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('student_violation_degrees', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('namazeg_version_id');
       
            $table->unsignedBigInteger('student_id');
            $table->integer('bad_value')->nullable();
            $table->integer('good_value')->nullable();
            $table->string('note')->nullable();
      
            $table->foreign('student_id')->references('id')->on('school_students')->onDelete('cascade');
            $table->foreign('namazeg_version_id')->references('id')->on('namazeg_versions')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('student_violation_degrees');
    }
};
