<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('namazeg_department_procedures_forms', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('v_student_punishment_id');
            $table->unsignedBigInteger('namazeg_version_id');
            $table->integer('decision_number');
            $table->string('date');
            $table->unsignedBigInteger('semester_id')->nullable();
            $table->unsignedBigInteger('class_id')->nullable();
            $table->string('new_school_name')->nullable();
            $table->string('options');

            $table->foreign('class_id')->references('id')->on('class_names')->onDelete('cascade');
            $table->foreign('semester_id','delte semes')->references('id')->on('semesters')->onDelete('cascade');
            $table->foreign('namazeg_version_id','delete versi')->references('id')->on('namazeg_versions')->onDelete('cascade');
            $table->foreign('v_student_punishment_id','delete v_s_punis')->references('id')->on('violation_student_punishments')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('namazeg_department_procedures_forms');
    }
};
