<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('exams_supervision_assignment_members', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('assignment_id');
            $table->unsignedBigInteger('employee_id');
            $table->string('assignment_work')->nullable();
            $table->string('mission')->nullable();
            $table->timestamps();

            $table->foreign('assignment_id')->references('id')->on('exams_supervision_assignments')->onDelete('cascade');
            $table->foreign('employee_id')->references('id')->on('school_employees')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('exams_supervision_assignment_members');
    }
};
