<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('namazeg_violation_proceeds', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('v_student_punishment_id');
            $table->unsignedBigInteger('namazeg_version_id');
            $table->integer('decision_number');
            $table->string('about');
            $table->string('date');
            $table->foreign('namazeg_version_id', 'deleter_version_proceeds')->references('id')->on('namazeg_versions')->onDelete('cascade');
            $table->foreign('v_student_punishment_id', 'delete_student_punishment')->references('id')->on('violation_student_punishments')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('namazeg_violation_proceeds');
    }
};
