<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('violation_student_punishments', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('violation_student_title_id');
            $table->unsignedInteger('punishment_id');
            $table->enum('status',['skipped','done','still'])->default('still');
            // skipped => make skip for this namozeg
            // done => make this namozeg
            // still => still didn't make this namozeg
            $table->unsignedBigInteger('namazeg_version_id')->nullable();
            $table->foreign('namazeg_version_id', 'delete verison namozeg')->references('id')->on('namazeg_versions')->onDelete('cascade');
            $table->foreign('violation_student_title_id','delete violation student title')->references('id')->on('violation_student_titles')->onDelete('cascade');
            $table->timestamps();   
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('violation_student_punishments');
    }
};
