<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('student_general_circulars', function (Blueprint $table) {
            $table->enum('directed_to',['class_name_and_number','class_name','all'])->after('title');
            $table->unsignedBigInteger('class_name_id')->after('directed_to')->nullable();
            $table->integer('class_number')->after('directed_to')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('student_general_circulars', function (Blueprint $table) {
            $table->dropColumn('directed_to');
            $table->dropColumn('class_name_id');
            $table->dropColumn('class_number');
        });
    }
};
