<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('namazeg_transform_quran_students', function (Blueprint $table) {
            $table->string('n_faild_years')->nullable();
            $table->string('faild_subjects')->nullable();
            $table->string('n_stoped_years')->nullable();
            $table->string('stoped_reasons')->nullable();
            $table->string('form_department_number')->nullable();
            $table->string('form_department_date')->nullable();
            $table->json('degrees')->nullable();  // Assuming degrees is an array, we use JSON type.
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('namazeg_transform_quran_students', function (Blueprint $table) {
            // Dropping the columns added in the up() method
            $table->dropColumn([
                'n_faild_years',
                'faild_subjects',
                'n_stoped_years',
                'stoped_reasons',
                'form_department_number',
                'form_department_date',
                'form_department_date_type',
                'degrees'
            ]);
        });
    }
};
