<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $tables = [
            'namazeg_absence_descion_confirms',
            'namazeg_absence_questionings',
            'namazeg_accept_students',
            'namazeg_assign_professional_communities',
            'namazeg_assign_professional_communities_employees',
            'namazeg_books_deliveries',
            'namazeg_chemist_lab_inventory_records',
            'namazeg_circular_attendances',
            'namazeg_class_plan_activities',
            'namazeg_descion_sumhours_lateleavings',
            'namazeg_employee_leaving_records',
            'namazeg_evacuation_plan_images',
            'namazeg_evacuation_plan_reports',
            'namazeg_excess_damage_records',
            'namazeg_experments_plans',
            'namazeg_experment_excution_records',
            'namazeg_final_report_class_activities',
            'namazeg_guardian_trans_froms',
            'namazeg_lab_inventory_records',
            'namazeg_maintenance_forms',
            'namazeg_monitoring_late_absence_teachers',
            'namazeg_notify_late_leavings',
            'namazeg_questionings',
            'namazeg_reciept_records',
            'namazeg_school_commitments',
            'namazeg_student_data',
            'namazeg_student_follows',
            'namazeg_teacher_excuses',
            'namazeg_teacher_performance_follows',
            'namazeg_transform_quran_students'
        ];

        foreach ($tables as $table) {
            Schema::table($table, function (Blueprint $table) {
                $table->softDeletes();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        $tables = [
            'namazeg_absence_descion_confirms',
            'namazeg_absence_questionings',
            'namazeg_accept_students',
            'namazeg_assign_professional_communities',
            'namazeg_assign_professional_communities_employees',
            'namazeg_books_deliveries',
            'namazeg_chemist_lab_inventory_records',
            'namazeg_circular_attendances',
            'namazeg_class_plan_activities',
            'namazeg_descion_sumhours_lateleavings',
            'namazeg_employee_leaving_records',
            'namazeg_evacuation_plan_images',
            'namazeg_evacuation_plan_reports',
            'namazeg_excess_damage_records',
            'namazeg_experments_plans',
            'namazeg_experment_excution_records',
            'namazeg_final_report_class_activities',
            'namazeg_guardian_trans_froms',
            'namazeg_lab_inventory_records',
            'namazeg_maintenance_forms',
            'namazeg_monitoring_late_absence_teachers',
            'namazeg_notify_late_leavings',
            'namazeg_questionings',
            'namazeg_reciept_records',
            'namazeg_school_commitments',
            'namazeg_student_data',
            'namazeg_student_follows',
            'namazeg_teacher_excuses',
            'namazeg_teacher_performance_follows',
            'namazeg_transform_quran_students'
        ];

        foreach ($tables as $table) {
            Schema::table($table, function (Blueprint $table) {
                $table->dropSoftDeletes();
            });
        }
    }
};
