<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('class_visit_rates', function (Blueprint $table) {
        
            $table->longText('class_visit_meeting_teacher_desc')->after('class_visit_meeting_teacher')->nullable();
            $table->longText('know_participation_subject_activities_desc')->after('know_participation_subject_activities')->nullable();
            $table->longText('review_written_preparation_lesson_desc')->after('review_written_preparation_lesson')->nullable();
            $table->longText('discussion_school_manager_desc')->after('discussion_school_manager')->nullable();
            $table->enum('make_short_test_students_rate', ['yes', 'no'])->default('yes')->after('discussion_school_manager_desc');
            $table->longText('make_short_test_students_desc')->after('make_short_test_students_rate')->nullable();
            $table->longText('view_assignments_applications_desc')->after('view_assignments_applications')->nullable();
            $table->longText('visit_student_mentor_desc')->after('visit_student_mentor')->nullable();
            $table->longText('view_calendar_tests_desc')->after('view_calendar_tests')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('class_visit_rates', function (Blueprint $table) {
            $table->dropColumn([
                'class_visit_meeting_teacher_desc',
                'know_participation_subject_activities_desc',
                'review_written_preparation_lesson_desc',
                'discussion_school_manager_desc',
                'make_short_test_students_rate',
                'make_short_test_students_desc',
                'view_assignments_applications_desc',
                'visit_student_mentor_desc',
                'view_calendar_tests_desc'
            ]);
        });
    }
};
