<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('namazeg_books_deliveries', function (Blueprint $table) {
            $table->dropColumn('type');
            $table->unsignedBigInteger('class_id')->nullable();
            $table->dropColumn('type_value');
        });
        
        
    }
    
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('namazeg_books_deliveries', function (Blueprint $table) {

            $table->enum('type', ['all_classes', 'class_id', 'school_class_id']);
            $table->dropColumn('class_id');
            $table->unsignedBigInteger('type_value')->nullable();


        });
    }
};
