<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('namazeg_class_plan_activities', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('namazeg_version_id');
            $table->unsignedBigInteger('school_id');

            $table->string('n_classes',100);
            $table->string('emplyee_ids');
            $table->string('specializations_ids');

            $table->foreign('namazeg_version_id')->references('id')->on('namazeg_versions')->onDelete('cascade');
            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('namazeg_class_plan_activities');
    }
};
