<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('namazeg_manager_plane_details', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('namazeg_manager_plane_id');
            $table->string('work_details');
            $table->enum('type', ['work_to_be_done', 'suggested_work']);
            $table->string('days');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('namazeg_manager_plane_details');
    }
};
