<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('assignment_committee_members', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('committee_id');
            $table->unsignedBigInteger('assignment_committee_id');
            $table->unsignedBigInteger('employee_id');
            $table->string('assignment_work');
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('committee_id')->references('id')->on('committees')->onDelete('cascade');
            $table->foreign('assignment_committee_id')->references('id')->on('assignment_committees')->onDelete('cascade');
            $table->foreign('employee_id')->references('id')->on('school_employees')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('assignment_committee_members');
    }
};
