<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('notification_receptors', function (Blueprint $table) {
            $table->integer('user_id')->nullable()->after('id');
            $table->enum('user_type',['student','employee'])->after('id');
            $table->boolean('seen')->default(0)->after('user_id');
            $table->boolean('open')->default(0)->after('notification_id');
            $table->dropColumn('deleted_at');
        });
        Schema::table('notifications', function (Blueprint $table) {
            $table->string('model',150)->nullable()->after('receptor');
            $table->integer('model_id')->nullable()->after('receptor');
            $table->enum('notification_type',['website','app'])->nullable()->after('date_type');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('notification_receptors', function (Blueprint $table) {
            $table->dropColumn('user_id');
            $table->dropColumn('user_type');
            $table->dropColumn('seen');
            $table->softDeletes();

        });
        Schema::table('notifications', function (Blueprint $table) {
            $table->dropColumn('model');
            $table->dropColumn('model_id');
            $table->dropColumn('notification_type');
        });
    }
};
