<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('violation_assigns_', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('school_class_id');
            $table->unsignedBigInteger('user_id');
            $table->boolean('for_government')->default(0);
            $table->unsignedBigInteger('violation_grade_id');
            $table->enum('date_type',['coptic','hijri'])->nullable();
            $table->string('date')->nullable();
            $table->enum('crime_date_type',['coptic','hijri'])->nullable();
            $table->string('crime_date')->nullable();
            $table->unsignedBigInteger('violation_title_id');
            $table->string('namozeg_ids')->nullable();
            $table->string('committee_action_number')->nullable();
            $table->string('committee_subject')->nullable();
            $table->enum('committee_date_type',['coptic','hijri'])->nullable();
            $table->string('committee_date')->nullable();
            $table->string('administration_number')->nullable();
            $table->enum('administration_date_type',['coptic','hijri'])->nullable();
            $table->string('administration_date')->nullable();

            $table->foreign('school_class_id')->references('id')->on('school_classes')->onDelete('cascade');
            $table->foreign('user_id')->references('id')->on('school_classes')->onDelete('cascade');
            $table->foreign('violation_grade_id')->references('id')->on('violation_grades')->onDelete('cascade');
            $table->foreign('violation_title_id')->references('id')->on('violation_titles')->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('violation_assigns_');
    }
};
