<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('teacher_general_circulars_teachers', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('teacher_general_circular_id')->nullable();
            $table->unsignedBigInteger('school_employee_id')->nullable();
            $table->timestamps();
            $table->softDeletes();

            // Foreign key constraint for parent student general circular
            $table->foreign('teacher_general_circular_id','sgc_teacher_sgc_id_fk')->references('id')->on('teacher_general_circulars')->onDelete('cascade');
            // Foreign key constraint for parent student
            $table->foreign('school_employee_id')->references('id')->on('school_employees')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('teacher_general_circulars_teachers');
    }
};
