<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('internal_circulars_teachers', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('internal_circular_id')->nullable();
            $table->unsignedBigInteger('school_employee_id')->nullable();
            $table->timestamps();
            $table->softDeletes();

            // Foreign key constraint for parent internal circular
            $table->foreign('internal_circular_id')->references('id')->on('internal_circulars')->onDelete('cascade');
            // Foreign key constraint for parent teacher
            $table->foreign('school_employee_id')->references('id')->on('school_employees')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('internal_circulars_teachers');
    }
};
