<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('violation_titles', function (Blueprint $table) {
            $table->id();
            $table->string('name', 150)->nullable();
            $table->unsignedBigInteger('violation_grade_id');
            $table->foreign('violation_grade_id')->references('id')->on('violation_grades')->onDelete('cascade');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('violation_titles');
    }
};
