<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('coupons', function (Blueprint $table) {
          
            $table->id();
            $table->string('code');
            $table->enum('discount_type', ['percentage', 'fixed'])->default('percentage');
            $table->integer('discount_value')->default(0);
            $table->enum('coupon_status', ['active', 'expired'])->default('active');
            $table->string('expiration_date')->nullable();
            $table->enum('expiration_date_type', ['hijri', 'coptic',])->nullable(); 
            $table->integer('minimum_purchase')->default(0); 
            $table->integer('maximum_purchase_limit')->nullable();
            $table->enum('usage_status_for_users', ['limited', 'unlimited'])->default('unlimited'); 
            $table->integer('usage_limit_per_coupon')->nullable();
            $table->enum('usage_status_for_user', ['limited', 'unlimited'])->default('unlimited'); 
            $table->integer('usage_limit_per_user')->nullable();
            $table->timestamps();
            $table->softDeletes(); 
        });

        
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('coupons');
    }
};
